#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAXN 200000

typedef struct Node {
    long long key;
    int id;
    int prio;
    struct Node *l, *r;
    int sz;
    long long sum;
} Node;

static int N, Q;
static int a[MAXN+1];
static long long total_sum;
static long long freq[MAXN+1];
static long long wv[MAXN+1];
static Node *root = NULL;
static void pull(Node *t) {
    if (!t) return;
    t->sz = 1;
    t->sum = t->key;
    if (t->l) { t->sz += t->l->sz; t->sum += t->l->sum; }
    if (t->r) { t->sz += t->r->sz; t->sum += t->r->sum; }
}
static int less(Node *a, Node *b) {
    if (a->key != b->key) return a->key < b->key;
    return a->id < b->id;
}

static Node* new_node(long long key, int id) {
    Node *t = (Node*)malloc(sizeof(Node));
    t->key = key;
    t->id = id;
    t->prio = rand();
    t->l = t->r = NULL;
    t->sz = 1;
    t->sum = key;
    return t;
}
static void split(Node *t, long long key, int id, Node **l, Node **r) {
    if (!t) { *l = *r = NULL; return; }
    Node temp; temp.key = key; temp.id = id;
    if (less(t, &temp)) {
        split(t->r, key, id, &t->r, r);
        *l = t; pull(*l);
    } else {
        split(t->l, key, id, l, &t->l);
        *r = t; pull(*r);
    }
}

static Node* merge(Node *l, Node *r) {
    if (!l || !r) return l ? l : r;
    if (l->prio > r->prio) {
        l->r = merge(l->r, r);
        pull(l);
        return l;
    } else {
        r->l = merge(l, r->l);
        pull(r);
        return r;
    }
}

static void insert(Node **t, Node *it) {
    if (!*t) { *t = it; return; }
    Node temp; temp.key = it->key; temp.id = it->id;
    if (it->prio > (*t)->prio) {
        split(*t, it->key, it->id, &it->l, &it->r);
        *t = it;
    } else if (less(it, *t)) {
        insert(&(*t)->l, it);
    } else {
        insert(&(*t)->r, it);
    }
    pull(*t);
}

static void erase(Node **t, long long key, int id) {
    if (!*t) return;
    Node temp; temp.key = key; temp.id = id;
    if ((*t)->key == key && (*t)->id == id) {
        Node *old = *t;
        *t = merge((*t)->l, (*t)->r);
        free(old);
    } else if (less(&temp, *t)) {
        erase(&(*t)->l, key, id);
    } else {
        erase(&(*t)->r, key, id);
    }
    if (*t) pull(*t);
}
static long long sum_top_L(Node *t, int L) {
    if (!t || L <= 0) return 0;
    int rs = t->r ? t->r->sz : 0;
    long long rsum = t->r ? t->r->sum : 0;
    if (L <= rs) {
        return sum_top_L(t->r, L);
    } else {
        long long take_right = rsum;
        int remain = L - rs;
        long long take_cur = (remain >= 1) ? t->key : 0;
        long long take_left = 0;
        if (remain > 1) {
            take_left = sum_top_L(t->l, remain - 1);
        }
        return take_right + take_cur + take_left;
    }
}

int main() {
    srand((unsigned)time(NULL));

    if (scanf("%d %d", &N, &Q) != 2) return 0;
    total_sum = 0;
    for (int i = 1; i <= N; i++) {
        scanf("%d", &a[i]);
        total_sum += a[i];
        freq[a[i]]++;
    }
    for (int v = 1; v <= N; v++) {
        if (freq[v] > 0) {
            wv[v] = (long long)v * freq[v];
            insert(&root, new_node(wv[v], v));
        }
    }

    while (Q--) {
        int t;
        if (scanf("%d", &t) != 1) return 0;
        if (t == 1) {
            int x;
            scanf("%d", &x);
            int L = N - x;
            int distinct = root ? root->sz : 0;
            if (L <= 0) {
                printf("%lld\n", total_sum);
            } else {
                if (L > distinct) L = distinct;
                long long remove_sum = sum_top_L(root, L);
                long long ans = total_sum - remove_sum;
                if (ans < 0) ans = 0;
                printf("%lld\n", ans);
            }
        } else if (t == 2) {
            int pos, val;
            scanf("%d %d", &pos, &val);
            if (pos < 1 || pos > N) continue;
            int old = a[pos];
            if (old == val) continue;
            total_sum += (long long)val - old;
            if (freq[old] > 0) {
                if (wv[old] > 0) erase(&root, wv[old], old);
                freq[old]--;
                wv[old] = freq[old] > 0 ? (long long)old * freq[old] : 0;
                if (freq[old] > 0) insert(&root, new_node(wv[old], old));
            } else {
            }
            if (freq[val] > 0) {
                erase(&root, wv[val], val);
            }
            freq[val]++;
            wv[val] = (long long)val * freq[val];
            insert(&root, new_node(wv[val], val));

            a[pos] = val;
        }
    }

    return 0;
}